<?php

    /**
     *	Math plugin
     *  http://www.mathjax.org
     *
     *	@package Monstra
     *  @subpackage Plugins
     *	@author Romanenko Sergey / Awilum
     *	@copyright 2012 Romanenko Sergey / Awilum
     *	@version 1.0.0
     *
     */


    // Register plugin
    Plugin::register( __FILE__,                    
                    __('Math'),
                    __('Math plugin for Monstra.'),  
                    '1.0.0',
                    'Awilum',                 
                    'http://monstra.org');
  

    // Add hook
    Action::add('theme_header', 'Math::themesHeaders');


    /**
     * Math class
     * 
     * LaTeX: $$ \left( \sum_{k=1}^n a_k b_k \right)^2 \leq \left( \sum_{k=1}^n a_k^2 \right) \left( \sum_{k=1}^n b_k^2 \right) $$
     * 
     */
    class Math {
         
        /**
         * Math Headers
         */
        public static function themesHeaders() {
            echo ('<script type="text/javascript" src="http://cdn.mathjax.org/mathjax/1.1-latest/MathJax.js?config=TeX-AMS_HTML"></script>');
        }

    }
