<?php



    // Admin Navigation: add new item

    Navigation::add(__('Background', 'Background'), 'content', 'background', 10);



    /**

     * Background admin class

     */

    class BackgroundAdmin extends Backend {



        public static function headers() {

            echo ('<script type="text/javascript" src="'.Option::get('siteurl').'plugins/background/assets/farbtastic.js"></script>');

            echo ('<link rel="stylesheet" href="'.Option::get('siteurl').'plugins/background/assets/farbtastic.css" />');

            echo ('<script>$(function(){ $("#farbtastic").farbtastic(".sel-color"); });</script>');



        }





	    public static function main() {



              //.......................//

             //  filesadmin by Awilum //

            //.......................//



            // Array of forbidden types

            $forbidden_types = array('php', 'htaccess', 'html', 'htm', 'empty');



            // Array of image types

            $image_types = array('jpg', 'png', 'bmp', 'gif', 'tif');



            // Get Site url

            $site_url = Option::get('siteurl');



            // Init vars

            if (Request::get('path')) $path = Request::get('path'); else $path = 'uploads/';



            // Add slash if not exists

            if (substr($path, -1, 1) != '/') {

                $path .= '/';

                Request::redirect($site_url.'admin/index.php?id=background&path='.$path);

            }



            // Upload corectly!

            if ($path == 'uploads' || $path == 'uploads//') {

                $path = 'uploads/';

                Request::redirect($site_url.'admin/index.php?id=background&path='.$path);

            }



            // Only 'uploads' folder!

            if (strpos($path, 'uploads') === false) {

                $path = 'uploads/';

                Request::redirect($site_url.'admin/index.php?id=background&path='.$path);

            }



            // Set default path value if path is empty

            if ($path == '') {

                $path = 'uploads/';

                Request::redirect($site_url.'admin/index.php?id=background&path='.$path);

            }



            $files_path = ROOT . DS . 'public' . DS . $path;

            $files_list = array();



            $current = explode('/', $path);



            // Get information about current path

            $_list = BackgroundAdmin::fdir($files_path);



            $files_list = array();



            // Get files

            if (isset($_list['files'])) {

                foreach ($_list['files'] as $files) {

                    $files_list[] = $files;

                }

            }



            $dir_list = array();



            // Get dirs

            if (isset($_list['dirs'])) {

                foreach ($_list['dirs'] as $dirs) {

                    if (strpos($dirs, '.') === false) $dir_list[] = $dirs;

                }

            }



            // Upload file

            // -------------------------------------

            if (Request::post('upload_file')) {

                if (Security::check(Request::post('csrf'))) {

                    if ($_FILES['file']) {

                        if ( ! in_array(File::ext($_FILES['file']['name']), $forbidden_types)) {

                            $background = $_FILES['file']['name'];

                            Option::update('background_img', $background );

                            move_uploaded_file($_FILES['file']['tmp_name'], $files_path.Security::safeName(basename($_FILES['file']['name'], File::ext($_FILES['file']['name'])), '-', true).'.'.File::ext($_FILES['file']['name']));

                            Request::redirect($site_url.'admin/index.php?id=background&path='.$path);

                        }

                    }

                } else { die('csrf detected!'); }

            }



            // Display view

            View::factory('background/views/backend/index')

                    ->assign('path', $path)

                    ->assign('current', $current)

                    ->assign('files_list', $files_list)

                    ->assign('dir_list', $dir_list)

                    ->assign('forbidden_types', $forbidden_types)

                    ->assign('image_types', $image_types)

                    ->assign('site_url', $site_url)

                    ->assign('files_path', $files_path)

                    ->display();

	    }



        protected static function fdir($dir, $type = null) {

            $files = array();

            $c = 0;

            $_dir = $dir;

            if (is_dir($dir)) {

            $dir = opendir ($dir);

                while (false !== ($file = readdir($dir))) {

                    if (($file !=".") && ($file !="..")) {

                        $c++;

                        if (is_dir($_dir.$file)) {

                            $files['dirs'][$c] = $file;

                        } else {

                            $files['files'][$c] = $file;

                        }

                    }

                }

                closedir($dir);

                return $files;

            } else {

                return false;

            }

        }



        public static function Background(){



            $site_url = Option::get('siteurl');

            $file =  Option::get('background_img');

            $repeat = Option::get('background_Repeat');

            $position = Option::get('background_Position');

            $atachment = Option::get('background_Atachment');

            $color = Option::get('background_Color');





            if (Request::post('delete_background')) {



                File::delete("../public/uploads/".$file);

                Option::update('background_img');

                Option::update('background_Repeat');

                Option::update('background_Position');

                Option::update('background_Atachment');

            }



            if (File::exists( UPLOADS . DS . $file)) {



                $background = '../public/uploads/'.$file;



                echo (

                    '<style> .custom-background{background:url("'.$background.'")'.$repeat.' '.$position.' top '.$atachment.' '.$color.';}</style>

                    <script type="text/javascript">

                        $(function(){



                            // Show panel

                            $(".box-panel").show();



                            // Show panel

                            $(".box-color").hide();



                        });

                    </script> ');

            }else{



                echo ('<style> .custom-background{background:'.$color.';}</style>');



            }

       }





       public static function BackgroundForm(){

            if(Request::post('Background_Color')) $Background_Color = Request::post('Background_Color'); else $Background_Color = Option::get('background_Color');



            if(isset($_POST['save_Background'])) {

                if(isset($_POST['background_Repeat'][0])) Option::update('background_Repeat', $_POST['background_Repeat'][0]);

                if(isset($_POST['background_Repeat'][1])) Option::update('background_Repeat', $_POST['background_Repeat'][1]);

                if(isset($_POST['background_Position'][0])) Option::update('background_Position', $_POST['background_Position'][0]);

                if(isset($_POST['background_Position'][1])) Option::update('background_Position', $_POST['background_Position'][1]);

                if(isset($_POST['background_Position'][2])) Option::update('background_Position', $_POST['background_Position'][2]);

                if(isset($_POST['background_Atachment'][0])) Option::update('background_Atachment', $_POST['background_Atachment'][0]);

                if(isset($_POST['background_Atachment'][1])) Option::update('background_Atachment', $_POST['background_Atachment'][1]);



                Option::update('background_Color',$Background_Color);

                Request::redirect(Option::get('siteurl').'admin/index.php?id=background');

                Notification::setNow('success', __('Success'));



            }

            echo (

                Form::open(null, array('class' => 'form-inline')).

                Form::radio('background_Repeat[]', 'repeat') . ' ' . __('Repeat', 'background') . ' ' . Html::nbsp().

                Form::radio('background_Repeat[]', 'no-repeat') . ' ' . __('No-repeat', 'background') . ' ' . Html::nbsp(8).

                Form::radio('background_Position[]', 'left') . ' ' . __('Left', 'background') . ' ' . Html::nbsp().

                Form::radio('background_Position[]', 'center') . ' ' . __('Center', 'background') . ' ' . Html::nbsp().

                Form::radio('background_Position[]', 'right') . ' ' . __('Right', 'background') . ' ' . Html::nbsp(8).

                Form::radio('background_Atachment[]', 'scroll') . ' ' . __('Scroll', 'background') . ' ' . Html::nbsp().

                Form::radio('background_Atachment[]', 'fixed') . ' ' . __('Fixed', 'background') . ' ' . Html::br(2).

                Form::input('Background_Color',$Background_Color, array('class' => 'sel-color', 'size' => '25')).Html::nbsp().

                Form::submit('save_Background', __('Save', 'background'), array('class' => 'btn default btn-small')).

                Form::close());

       }





       public static function BackgroundForm_Color(){

            if (Request::post('Background_Color')) $Background_Color = Request::post('Background_Color'); else $Background_Color = Option::get('background_Color');

            if (Request::post('save_Color')){

                Option::update('background_Color',$Background_Color);

                Request::redirect(Option::get('siteurl').'admin/index.php?id=background');

                Notification::setNow('success', __('Success'));

            }

            echo (

                Form::open(null, array('class' => 'form-inline')).

                Form::input('Background_Color',$Background_Color, array('class' => 'sel-color', 'size' => '25')).Html::nbsp().

                Form::submit('save_Color', __('Save', 'background'), array('class' => 'btn default btn-small')).

                Form::close()

            );

       }

	}